#!/bin/bash
SRC_DIR="${BASH_SOURCE[0]}"
SRC_DIR="$( dirname $SRC_DIR )"
cd $SRC_DIR
EXE_FILE="./vpix_server_mac_64"
ts="$(date +%Y%m%d%H%M%S)"

$EXE_FILE $ts &
PID="$(ps aux | grep $EXE_FILE | grep -v grep | awk '{print $2}')"

function clean_up {
    kill -TERM "$PID"
}

APPLESCRIPT=`cat <<EOF
try
  tell application "Finder"
    set app_name to "com.google.Chrome"
    set appname to name of application file id app_name
    return 1
  end tell
on error err_msg number err_num
  return 0
end try
EOF`

retcode=`osascript -e "$APPLESCRIPT"`
if [ $retcode -eq 1 ]; then
    CHROME="$(open -a Google\ Chrome http://127.0.0.1:55123/$ts/tour.html > /dev/null 2>&1)"
else
    SAFARI="$(open -a Safari http://127.0.0.1:55123/$ts/tour.html > /dev/null 2>&1)"
fi

echo "Started the browser"
printf "Press X to stop the tour server ...\n"
read -n1 -s key
key=$(echo "$key" | tr '[a-z]' '[A-Z]]')

while [ "$key" != "X" ]; do
    printf "Press X to stop ...\n"
    read -n1 -s key
    key=$(echo "$key" | tr '[a-z]' '[A-Z]]')
done

trap clean_up EXIT SIGHUP SIGINT SIGTERM

